package com.example.sefinsa_app.ui.rmd.Ver;

import static com.example.sefinsa_app.utilities.BluetoothUtils.mConnectedThread;

import android.annotation.SuppressLint;
import android.app.ProgressDialog;
import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.text.Html;
import android.util.Base64;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.example.sefinsa_app.DashboardActivity;
import com.example.sefinsa_app.R;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.RMDController;
import com.example.sefinsa_app.models.Articulo;
import com.example.sefinsa_app.models.RMD;
import com.example.sefinsa_app.ui.rmd.RMDFragment;
import com.example.sefinsa_app.utilities.BluetoothUtils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Objects;

public class RMDAdapter extends RecyclerView.Adapter<RMDAdapter.ViewHolder> {
    ArrayList<RMD> rmd;
    private RMDFragment fragment;
    private Context context;
    private FragmentActivity activity;
    private RMDController rmdController;

    public RMDAdapter(ArrayList<RMD> rmd, RMDFragment fragment, Context context, FragmentActivity activity) {
        this.rmd = rmd;
        this.fragment = fragment;
        this.context = context;
        this.activity = activity;
        rmdController = new RMDController(context, activity);
    }

    public static class ViewHolder extends RecyclerView.ViewHolder {
        private TextView txtVwFolio;
        private TextView txtVwFecha;
        private TextView txtWvNombre;
        private TextView txtVwNoCuenta;
        private TextView txtVwPoblacion;
        private Button btnDetalles;
        private Button btnArchivos;

        public ViewHolder(@NonNull View view) {
            super(view);

            txtVwFolio = view.findViewById(R.id.txtVwFolio);
            txtVwFecha = view.findViewById(R.id.txtVwFecha);
            txtWvNombre = view.findViewById(R.id.txtWvNombre);
            txtVwNoCuenta = view.findViewById(R.id.txtVwNoCuenta);
            txtVwPoblacion = view.findViewById(R.id.txtVwPoblacion);
            btnDetalles = view.findViewById(R.id.btnDetalles);
            btnArchivos = view.findViewById(R.id.btnArchivos);
        }
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.rmd_item, parent, false);
        return new ViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        String folio = rmd.get(position).getId();
        String fecha = rmd.get(position).getFecha();
        String nombre = rmd.get(position).getNombre();
        String noCuenta = rmd.get(position).getNumeroCuenta();
        String poblacion = rmd.get(position).getPoblacion();

        holder.txtVwFolio.setText("Folio: " + folio);
        holder.txtVwFecha.setText(fecha);
        holder.txtWvNombre.setText("Nombre: " + nombre);
        holder.txtVwNoCuenta.setText("No. Cuenta: " + noCuenta);
        holder.txtVwPoblacion.setText("Población: " + poblacion);

        holder.btnDetalles.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                RMD rmd = rmdController.getRMD(folio);

                AlertDialog.Builder builder = new AlertDialog.Builder(context);
                View dialogLayout = LayoutInflater.from(context).inflate(R.layout.dialog_rmd, null);
                builder.setView(dialogLayout);

                @SuppressLint({"MissingInflatedId", "LocalSuppress"}) TextView txtVwFolio = dialogLayout.findViewById(R.id.txtVwFolio);
                @SuppressLint({"MissingInflatedId", "LocalSuppress"}) TextView txtVwFecha = dialogLayout.findViewById(R.id.txtVwFecha);
                @SuppressLint({"MissingInflatedId", "LocalSuppress"}) TextView txtVwNoCuenta = dialogLayout.findViewById(R.id.txtVwNoCuenta);
                @SuppressLint({"MissingInflatedId", "LocalSuppress"}) TextView txtVwNombre = dialogLayout.findViewById(R.id.txtVwNombre);
                @SuppressLint({"MissingInflatedId", "LocalSuppress"}) TextView txtVwPoblacion = dialogLayout.findViewById(R.id.txtVwPoblacion);
                @SuppressLint({"MissingInflatedId", "LocalSuppress"}) RecyclerView rvArticulosDetalleRMD = dialogLayout.findViewById(R.id.rvArticulosDetalleRMD);
                @SuppressLint({"MissingInflatedId", "LocalSuppress"}) TextView txtVwValorGarantia = dialogLayout.findViewById(R.id.txtVwValorGarantia);
                @SuppressLint({"MissingInflatedId", "LocalSuppress"}) TextView txtVwPagara = dialogLayout.findViewById(R.id.txtVwPagara);
                @SuppressLint({"MissingInflatedId", "LocalSuppress"}) TextView txtVwRuta = dialogLayout.findViewById(R.id.txtVwRuta);
                @SuppressLint({"MissingInflatedId", "LocalSuppress"}) TextView txtVwFechaPago = dialogLayout.findViewById(R.id.txtVwFechaPago);
                @SuppressLint({"MissingInflatedId", "LocalSuppress"}) ImageView imgFirmaCliente = dialogLayout.findViewById(R.id.imgFirmaCliente);
                @SuppressLint({"MissingInflatedId", "LocalSuppress"}) ImageView imgFirmaAsesor = dialogLayout.findViewById(R.id.imgFirmaAsesor);
                @SuppressLint({"MissingInflatedId", "LocalSuppress"}) TextView txtVwRecibeMercancia = dialogLayout.findViewById(R.id.txtVwRecibeMercancia);

                String folio = rmd.getId();
                String fecha = rmd.getFecha();
                String nombre = rmd.getNombre();
                String noCuenta = rmd.getNumeroCuenta();
                String ruta = rmd.getRuta();
                String poblacion = rmd.getPoblacion();
                String valorGarantia = rmd.getValorGarantia();
                String pagara = rmd.getPagara();
                String recibeMercancia = rmd.getRecibeMercancia();
                Bitmap firmaCliente = base64ToBitmap(rmd.getFirmaCliente());
                Bitmap firmaAsesor = base64ToBitmap(rmd.getFirmaAsesor());
                String fechaPago = rmd.getFechaIns();

                imgFirmaCliente.setImageBitmap(firmaCliente);
                imgFirmaAsesor.setImageBitmap(firmaAsesor);

                builder.setTitle("Detalles RMD");
                builder.setNegativeButton("Cerrar", new DialogInterface.OnClickListener() { @Override public void onClick(DialogInterface dialog, int which) { dialog.dismiss(); }});

                txtVwFolio.setText(Html.fromHtml("<b>Folio:</b> " + folio));
                txtVwFecha.setText(fecha);
                txtVwNoCuenta.setText(Html.fromHtml("<b>No. de Cuenta:</b> " + noCuenta));
                txtVwNombre.setText(Html.fromHtml("<b>Nombre:</b> " + nombre));
                txtVwRuta.setText(Html.fromHtml("<b>Ruta:</b> " + ruta));
                txtVwPoblacion.setText(Html.fromHtml("<b>Población:</b> " + poblacion));
                txtVwValorGarantia.setText(Html.fromHtml("<b>Valor garantía:</b> $" + valorGarantia));
                txtVwPagara.setText(Html.fromHtml("<b>Pagará:</b> $" + pagara));
                txtVwFechaPago.setText(Html.fromHtml("<b>Fecha: </b>" + fechaPago));
                txtVwRecibeMercancia.setText(Html.fromHtml("<b>Recibe mercancía:</b> " + recibeMercancia));

                ArrayList<Articulo> articulos = rmdController.getArticulos(folio);

                DetalleRMDArticuloAdapter adapter = new DetalleRMDArticuloAdapter(articulos, rmd.getId(), fragment, context, activity);
                RecyclerView.LayoutManager layoutManager = new LinearLayoutManager(context);
                rvArticulosDetalleRMD.setLayoutManager(layoutManager);
                rvArticulosDetalleRMD.setItemAnimator(new DefaultItemAnimator());
                rvArticulosDetalleRMD.setAdapter(adapter);

                AlertDialog dialog = builder.create();
                dialog.show();
            }
        });

        holder.btnArchivos.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                AlertDialog.Builder builder = new AlertDialog.Builder(context);

                builder.setTitle("Selecciona una opción");

                BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();

                builder.setPositiveButton("Imprimir Ticket", new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int id) {
                        if (mConnectedThread == null || !bluetoothAdapter.isEnabled()) {
                            mConnectedThread = null;
                            AlertDialog.Builder builder2 = new AlertDialog.Builder(context);

                            builder2.setTitle("No hay impresora conectada");
                            builder2.setMessage("¿Desea contectarse a una impresora?");
                            builder2.setPositiveButton("Conectarse", new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialog, int which) {
                                    ProgressDialog progressDialog = new ProgressDialog(context);

                                    if (!bluetoothAdapter.isEnabled()) {
                                        Toast.makeText(context, "Enciende el bluetooth para continuar", Toast.LENGTH_SHORT).show();
                                        AlertDialog d = builder2.create();
                                        progressDialog.dismiss();
                                        d.show();
                                    } else {
                                        DashboardActivity da = (DashboardActivity) activity;
                                        da.conectarImpresora(new DashboardActivity.ConexionCallback() {
                                            @Override
                                            public void onSuccess() {
                                                progressDialog.dismiss();
                                                AlertDialog dialog = builder.create();
                                                dialog.show();
                                            }
                                        });
                                    }
                                }
                            });

                            builder2.setNegativeButton("Cancelar", new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialog, int which) {
                                    dialog.dismiss();
                                }
                            });

                            builder2.setCancelable(false);
                            AlertDialog dialog2 = builder2.create();
                            dialog2.show();
                        } else {
                            try {
                                imprimirTicket(folio);
                                dialog.dismiss();
                            } catch (ParseException e) {
                                throw new RuntimeException(e);
                            } catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                            AlertDialog d = builder.create();
                            d.show();
                        }
                    }
                });

                builder.setNeutralButton("Cerrar", new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int id) {
                        dialog.dismiss();
                    }
                });

                builder.setNegativeButton("Compartir pdf", new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int id) {
                        dialog.dismiss();
                        try {
                            compartirPDF(folio);
                        } catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });

                AlertDialog dialog = builder.create();
                dialog.show();
            }
        });
    }

    public void imprimirTicket(String folio) throws ParseException, IOException {
        if (Objects.equals(API.url, API.urlCredigrup)) {
            BluetoothUtils.printPhoto(R.drawable.credigrup_ticket_3);
        } else {
            BluetoothUtils.printPhoto(R.drawable.sefinsa_ticket_4);
        }

        RMD rmd = rmdController.getRMDParaImpresion(folio);

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            BluetoothUtils.imprimirRMD(rmd);
        }
    }

    public void compartirPDF (String folio) throws IOException {
        RMD rmd = rmdController.getRMDParaImpresion(folio);

        String text = "----------------------------------------------------\n";
        text += "PRESTAMO GRUSEF S.A. de C.V.\n";
        text += "Folio: " + rmd.getId() + "\n";
        text += "Fecha: " + rmd.getFecha() + "\n";
        text += "No. Cuenta: " + rmd.getNumeroCuenta() + "\n";
        text += "Nombre: " + rmd.getNombre() + "\n";
        text += "Teléfono: " + rmd.getTelefono() + "\n";
        text += "Ruta: " + rmd.getRuta() + "\n";
        text += "Población: " + rmd.getPoblacion() + "\n\n";
        text += "Debido a que de inmediano no me\npuedo poner al corriente en los\npagos que me obligue a hacer en\nmi cuenta conforme al contrato\nfirmado que celebre con ustedes,\nhago entrega de las siguientes\ngarantias:\n\n";

        int i = 1;
        for (Articulo articulo : rmd.getArticulos()) {
            String nombre = configurar40Caracteres(articulo.getArticulo(), "Nombre");
            String marca = configurar40Caracteres(articulo.getMarca(), "Marca");
            String color = configurar40Caracteres(articulo.getColor(), "Color");
            String detalleCondiciones = configurar40Caracteres(articulo.getDetalleCondiciones(), "Detalles");

            text += "Articulo " + i + "\n";
            text += "Nombre: " + nombre + "\n";
            text += "Marca: " + marca + "\n";
            text += "Color: " + color + "\n";
            text += "Condiciones: " + detalleCondiciones + "\n\n";
            i++;
        }

        text += "Valor garantía: " + rmd.getValorGarantia() + "\n";
        text += "Pagará: $" + rmd.getPagara() + "\n";
        text += "Fecha: $" + rmd.getFechaIns() + "\n";
        text += "Recibe mercancía: " + rmd.getRecibeMercancia() + "\n\n";
        text += "Y LIQUIDARA EL ADEUDO EN LAS\nPROXIMAS 24 HORAS. DE INCUMPLIR\nCON DICHO ACUERDO ACEPTO QUE MIS\nGARANTIAS SEAN VENDIDAS PARA\nCUBRIR EL IMPORTE MENCIONADO EN\nEL VALOR DE GARANTIA.";

        File pdf = fragment.generarPDF(text, rmd.getFirmaCliente(), rmd.getFirmaAsesor(), rmd.getId());

        fragment.compartirPDF(pdf);
    }

    private static String configurar40Caracteres(String texto, String x) {
        String[] palabras = texto.split(" ");
        StringBuilder resultado = new StringBuilder();
        int countLinea = 0;
        if (Objects.equals(x, "Nombre")) countLinea = 8;
        if (Objects.equals(x, "Marca")) countLinea = 7;
        if (Objects.equals(x, "Color")) countLinea = 7;
        if (Objects.equals(x, "Detalles")) countLinea = 10;
        for (String palabra : palabras) {
            countLinea += palabra.length() + 1;
            if (countLinea > 40) {
                resultado.append("\n");
                countLinea = 0;
            }
            resultado.append(palabra).append(" ");
        }
        return resultado.toString().trim();
    }

    @Override
    public int getItemCount() { return rmd.size(); }

    public Bitmap base64ToBitmap(String base64) {
        byte[] decodedString = Base64.decode(base64, Base64.DEFAULT);
        return BitmapFactory.decodeByteArray(decodedString, 0, decodedString.length);
    }

    public String bitmapToBase64(Bitmap bitmap) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, byteArrayOutputStream);
        byte[] byteArray = byteArrayOutputStream.toByteArray();
        return Base64.encodeToString(byteArray, Base64.DEFAULT);
    }
}
